Ext.data.JsonP.sol_common_ix_DynKwlBLPIterator({"tagname":"class","name":"sol.common.ix.DynKwlBLPIterator","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"lib_sol.common.ix.DynKwlBLPIterator.js","href":"lib_sol.common.ix.DynKwlBLPIterator.html#sol-common-ix-DynKwlBLPIterator"}],"author":[{"tagname":"author","name":"ELO Digital Office GmbH","email":null}],"eloix":true,"requires":["sol.common.HttpUtils","sol.common.Locale","sol.common.SordUtils","sol.common.StringUtils","sol.common.Template","sol.common.ix.DynKwlUtils"],"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":["sol.common.ix.DynKwlMixin"],"uses":[],"members":[{"name":"addInId","tagname":"cfg","owner":"sol.common.ix.DynKwlBLPIterator","id":"cfg-addInId","meta":{}},{"name":"appToken","tagname":"cfg","owner":"sol.common.ix.DynKwlBLPIterator","id":"cfg-appToken","meta":{}},{"name":"moduleId","tagname":"cfg","owner":"sol.common.ix.DynKwlBLPIterator","id":"cfg-moduleId","meta":{}},{"name":"projectId","tagname":"cfg","owner":"sol.common.ix.DynKwlBLPIterator","id":"cfg-projectId","meta":{}},{"name":"queryConditions","tagname":"cfg","owner":"sol.common.ix.DynKwlBLPIterator","id":"cfg-queryConditions","meta":{}},{"name":"queryModule","tagname":"cfg","owner":"sol.common.ix.DynKwlBLPIterator","id":"cfg-queryModule","meta":{}},{"name":"queryName","tagname":"cfg","owner":"sol.common.ix.DynKwlBLPIterator","id":"cfg-queryName","meta":{}},{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"serverUrl","tagname":"cfg","owner":"sol.common.ix.DynKwlBLPIterator","id":"cfg-serverUrl","meta":{}},{"name":"tableHeaders","tagname":"cfg","owner":"sol.common.ix.DynKwlBLPIterator","id":"cfg-tableHeaders","meta":{"required":true}},{"name":"tableKeyNames","tagname":"cfg","owner":"sol.common.ix.DynKwlBLPIterator","id":"cfg-tableKeyNames","meta":{"required":true}},{"name":"tableTitle","tagname":"cfg","owner":"sol.common.ix.DynKwlBLPIterator","id":"cfg-tableTitle","meta":{}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"errorMessage","tagname":"property","owner":"sol.common.ix.DynKwlBLPIterator","id":"property-errorMessage","meta":{"private":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"mixin","tagname":"property","owner":"sol.common.ix.DynKwlMixin","id":"property-mixin","meta":{"private":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"close","tagname":"method","owner":"sol.common.ix.DynKwlBLPIterator","id":"method-close","meta":{}},{"name":"createBLPConditionFields","tagname":"method","owner":"sol.common.ix.DynKwlBLPIterator","id":"method-createBLPConditionFields","meta":{}},{"name":"formatNumber","tagname":"method","owner":"sol.common.ix.DynKwlMixin","id":"method-formatNumber","meta":{"private":true}},{"name":"formatRow","tagname":"method","owner":"sol.common.ix.DynKwlMixin","id":"method-formatRow","meta":{"protected":true}},{"name":"getHeader","tagname":"method","owner":"sol.common.ix.DynKwlBLPIterator","id":"method-getHeader","meta":{}},{"name":"getIndexFromName","tagname":"method","owner":"sol.common.ix.DynKwlBLPIterator","id":"method-getIndexFromName","meta":{"private":true}},{"name":"getKeyNames","tagname":"method","owner":"sol.common.ix.DynKwlBLPIterator","id":"method-getKeyNames","meta":{}},{"name":"getMessage","tagname":"method","owner":"sol.common.ix.DynKwlBLPIterator","id":"method-getMessage","meta":{}},{"name":"getNextRow","tagname":"method","owner":"sol.common.ix.DynKwlBLPIterator","id":"method-getNextRow","meta":{}},{"name":"getQueryResults","tagname":"method","owner":"sol.common.ix.DynKwlBLPIterator","id":"method-getQueryResults","meta":{"private":true}},{"name":"getRowData","tagname":"method","owner":"sol.common.ix.DynKwlBLPIterator","id":"method-getRowData","meta":{}},{"name":"getTableKeyNames","tagname":"method","owner":"sol.common.ix.DynKwlMixin","id":"method-getTableKeyNames","meta":{"protected":true}},{"name":"getTitle","tagname":"method","owner":"sol.common.ix.DynKwlBLPIterator","id":"method-getTitle","meta":{}},{"name":"hasMoreRows","tagname":"method","owner":"sol.common.ix.DynKwlBLPIterator","id":"method-hasMoreRows","meta":{}},{"name":"initialize","tagname":"method","owner":"sol.common.ix.DynKwlBLPIterator","id":"method-initialize","meta":{"private":true}},{"name":"open","tagname":"method","owner":"sol.common.ix.DynKwlBLPIterator","id":"method-open","meta":{}},{"name":"openMap","tagname":"method","owner":"sol.common.ix.DynKwlBLPIterator","id":"method-openMap","meta":{}}],"code_type":"ext_define","id":"class-sol.common.ix.DynKwlBLPIterator","short_doc":"BLP Query Iterator used by dynamic keyword lists. ...","classIcon":"icon-class","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.ix.DynKwlBLPIterator</strong></div></div><h4>Mixins</h4><div class='dependency'><a href='#!/api/sol.common.ix.DynKwlMixin' rel='sol.common.ix.DynKwlMixin' class='docClass'>sol.common.ix.DynKwlMixin</a></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.HttpUtils' rel='sol.common.HttpUtils' class='docClass'>sol.common.HttpUtils</a></div><div class='dependency'><a href='#!/api/sol.common.Locale' rel='sol.common.Locale' class='docClass'>sol.common.Locale</a></div><div class='dependency'><a href='#!/api/sol.common.SordUtils' rel='sol.common.SordUtils' class='docClass'>sol.common.SordUtils</a></div><div class='dependency'><a href='#!/api/sol.common.StringUtils' rel='sol.common.StringUtils' class='docClass'>sol.common.StringUtils</a></div><div class='dependency'><a href='#!/api/sol.common.Template' rel='sol.common.Template' class='docClass'>sol.common.Template</a></div><div class='dependency'><a href='#!/api/sol.common.ix.DynKwlUtils' rel='sol.common.ix.DynKwlUtils' class='docClass'>sol.common.ix.DynKwlUtils</a></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.ix.DynKwlBLPIterator.html#sol-common-ix-DynKwlBLPIterator' target='_blank'>lib_sol.common.ix.DynKwlBLPIterator.js</a></div></pre><div class='doc-contents'><p>BLP Query Iterator used by dynamic keyword lists. This class provides an abstract layer that simplifies the usage\nof keywording information.</p>\n\n<p>This iterator has to be used in combination with a BLP query. When used in a GenericDynKwl we're extracting\nthe correct BLP values (e.g. queryName, addInId, moduleId, ...) within the DynKWL configuration app.\nWhen implemented via code you'll need to provide the specific properties yourself.</p>\n\n<h1>Example implementation</h1>\n\n<p>Implementation of an Index Server data iterator that can be used by keywording forms:</p>\n\n<p>   <a href=\"#!/api/sol-static-method-define\" rel=\"sol-static-method-define\" class=\"docClass\">sol.define</a>(\"sol.examples.ix.dynkwl.Customers\", {\n     extend: \"<a href=\"#!/api/sol.common.ix.DynKwlBLPIterator\" rel=\"sol.common.ix.DynKwlBLPIterator\" class=\"docClass\">sol.common.ix.DynKwlBLPIterator</a>\",</p>\n\n<pre><code> tableTitle: \"Customers of a ERP system\",\n tableKeyNames: [\"CUSTOMER_NO\", \"CUSTOMER_NAME\", \"IX_MAP_CUSTOMER_CATEGORY\"],\n serverUrl: \"http://10.1.2.10:30009\",\n appToken: \"HThYifwwAsdfYf400XSaiINismui3kTDOPqan8EoyfM=\",\n projectId: \"603c98f95675da5172eb84cb\",\n queryName: \"psql.navcustomers\",\n queryModule: \"OleDb\",\n moduleId: \"a7f28149-7202-43f2-b3ec-d225743b06ee\",\n addInId: \"da414d55-45b5-451a-a03a-9517727ae9c7\",\n queryConditions: [\n   { name: \"IDX1\", fieldName: \"CUSTOMER_NAME\" },\n   { name: \"IDX2\", value: \"IMPORTANT CUSTOMERS\" }\n ]\n</code></pre>\n\n<p>   });</p>\n\n<p>   function getDataIterator() {\n     var iterator;\n     iterator = <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>(\"sol.examples.ix.dynkwl.Customers\", {  });\n     return new DynamicKeywordDataProvider(iterator);\n   }</p>\n</div><div class='members'><div class='members-section'><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Required config options</h3><div id='cfg-tableHeaders' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlBLPIterator'>sol.common.ix.DynKwlBLPIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlBLPIterator.html#sol-common-ix-DynKwlBLPIterator-cfg-tableHeaders' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlBLPIterator-cfg-tableHeaders' class='name expandable'>tableHeaders</a> : Array<span class=\"signature\"><span class='required' >required</span></span></div><div class='description'><div class='short'>column header names. ...</div><div class='long'><p>column header names. if null column is hidden in the client.</p>\n\n<pre><code>[\"Name\", \"Description\"]\n</code></pre>\n</div></div></div><div id='cfg-tableKeyNames' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlBLPIterator'>sol.common.ix.DynKwlBLPIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlBLPIterator.html#sol-common-ix-DynKwlBLPIterator-cfg-tableKeyNames' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlBLPIterator-cfg-tableKeyNames' class='name expandable'>tableKeyNames</a> : Array<span class=\"signature\"><span class='required' >required</span></span></div><div class='description'><div class='short'>mapping between columns and elo group or map fields. ...</div><div class='long'><p>mapping between columns and elo group or map fields. if null, value is not transferred.</p>\n\n<pre><code>// GRP field     map static field           map table field\n['RECORD_REFERENCE', null];\n</code></pre>\n\n<p>Map fields must contain IX_MAP as a prefix and can optionally use {i} as a counter value.</p>\n</div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Optional config options</h3><div id='cfg-addInId' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlBLPIterator'>sol.common.ix.DynKwlBLPIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlBLPIterator.html#sol-common-ix-DynKwlBLPIterator-cfg-addInId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlBLPIterator-cfg-addInId' class='name expandable'>addInId</a> : string<span class=\"signature\"></span></div><div class='description'><div class='short'><p>ID of the BLP addIn (e.g.: \"da414d55-45b5-451a-a03a-9517727ae9c7\") to be used in this DynKWL</p>\n</div><div class='long'><p>ID of the BLP addIn (e.g.: \"da414d55-45b5-451a-a03a-9517727ae9c7\") to be used in this DynKWL</p>\n</div></div></div><div id='cfg-appToken' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlBLPIterator'>sol.common.ix.DynKwlBLPIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlBLPIterator.html#sol-common-ix-DynKwlBLPIterator-cfg-appToken' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlBLPIterator-cfg-appToken' class='name expandable'>appToken</a> : string<span class=\"signature\"></span></div><div class='description'><div class='short'>App token for BLP connection. ...</div><div class='long'><p>App token for BLP connection. Needs to be configured in the BLP designer within the Credential Store\nThis is the \"Secret Key\" within the \"Access Keys\"\n(e.g. HThYifwwAsdfYf400XSaiINismui3kTDOPqan8EoyfM=)</p>\n</div></div></div><div id='cfg-moduleId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlBLPIterator'>sol.common.ix.DynKwlBLPIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlBLPIterator.html#sol-common-ix-DynKwlBLPIterator-cfg-moduleId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlBLPIterator-cfg-moduleId' class='name expandable'>moduleId</a> : string<span class=\"signature\"></span></div><div class='description'><div class='short'><p>ID of the BLP module (e.g.: \"a7f28149-7202-43f2-b3ec-d225743b06ee for the DataConnect module\") to be used in this DynKWL</p>\n</div><div class='long'><p>ID of the BLP module (e.g.: \"a7f28149-7202-43f2-b3ec-d225743b06ee for the DataConnect module\") to be used in this DynKWL</p>\n</div></div></div><div id='cfg-projectId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlBLPIterator'>sol.common.ix.DynKwlBLPIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlBLPIterator.html#sol-common-ix-DynKwlBLPIterator-cfg-projectId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlBLPIterator-cfg-projectId' class='name expandable'>projectId</a> : string<span class=\"signature\"></span></div><div class='description'><div class='short'>Project Id for this BLP query. ...</div><div class='long'><p>Project Id for this BLP query. Can be the project name</p>\n</div></div></div><div id='cfg-queryConditions' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlBLPIterator'>sol.common.ix.DynKwlBLPIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlBLPIterator.html#sol-common-ix-DynKwlBLPIterator-cfg-queryConditions' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlBLPIterator-cfg-queryConditions' class='name expandable'>queryConditions</a> : Array<span class=\"signature\"></span></div><div class='description'><div class='short'>[{ \"name\": \"IDX1\", \"value\": \"20000\", message: 'field x missing' }]\n\nConditions to be passed to the BLP query\nIf no na...</div><div class='long'><p>[{ \"name\": \"IDX1\", \"value\": \"20000\", message: 'field x missing' }]</p>\n\n<p>Conditions to be passed to the BLP query\nIf no name is provied the current focuesd field is used.</p>\n<p>Defaults to: <code>[]</code></p></div></div></div><div id='cfg-queryModule' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlBLPIterator'>sol.common.ix.DynKwlBLPIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlBLPIterator.html#sol-common-ix-DynKwlBLPIterator-cfg-queryModule' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlBLPIterator-cfg-queryModule' class='name expandable'>queryModule</a> : string<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Name of the BLP module (e.g.: \"OleDb\") to be used in this DynKWL</p>\n</div><div class='long'><p>Name of the BLP module (e.g.: \"OleDb\") to be used in this DynKWL</p>\n</div></div></div><div id='cfg-queryName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlBLPIterator'>sol.common.ix.DynKwlBLPIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlBLPIterator.html#sol-common-ix-DynKwlBLPIterator-cfg-queryName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlBLPIterator-cfg-queryName' class='name expandable'>queryName</a> : string<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Name of the BLP query to be used in this DynKWL</p>\n</div><div class='long'><p>Name of the BLP query to be used in this DynKWL</p>\n</div></div></div><div id='cfg-requiredConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div><div id='cfg-serverUrl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlBLPIterator'>sol.common.ix.DynKwlBLPIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlBLPIterator.html#sol-common-ix-DynKwlBLPIterator-cfg-serverUrl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlBLPIterator-cfg-serverUrl' class='name expandable'>serverUrl</a> : string<span class=\"signature\"></span></div><div class='description'><div class='short'>URL of BLP server (e.g. ...</div><div class='long'><p>URL of BLP server (e.g. http://<IP Adress>:30009)</IP></p>\n</div></div></div><div id='cfg-tableTitle' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlBLPIterator'>sol.common.ix.DynKwlBLPIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlBLPIterator.html#sol-common-ix-DynKwlBLPIterator-cfg-tableTitle' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlBLPIterator-cfg-tableTitle' class='name expandable'>tableTitle</a> : string<span class=\"signature\"></span></div><div class='description'><div class='short'>name of this table. ...</div><div class='long'><p>name of this table. The title is displayed by the client.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-errorMessage' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlBLPIterator'>sol.common.ix.DynKwlBLPIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlBLPIterator.html#sol-common-ix-DynKwlBLPIterator-property-errorMessage' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlBLPIterator-property-errorMessage' class='name expandable'>errorMessage</a> : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Error message that is passed to the client if value is missing. ...</div><div class='long'><p>Error message that is passed to the client if value is missing.</p>\n<p>Defaults to: <code>&quot;&quot;</code></p></div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-property-logger\" rel=\"sol.common.ix.FunctionBase-property-logger\" class=\"docClass\">sol.common.ix.FunctionBase.logger</a>, <a href=\"#!/api/sol.common.ix.ServiceBase-property-logger\" rel=\"sol.common.ix.ServiceBase-property-logger\" class=\"docClass\">sol.common.ix.ServiceBase.logger</a></p></div></div></div><div id='property-mixin' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.DynKwlMixin' rel='sol.common.ix.DynKwlMixin' class='defined-in docClass'>sol.common.ix.DynKwlMixin</a><br/><a href='source/lib_sol.common.ix.DynKwlUtils.html#sol-common-ix-DynKwlMixin-property-mixin' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlMixin-property-mixin' class='name expandable'>mixin</a> : Boolean<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>true</code></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-close' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlBLPIterator'>sol.common.ix.DynKwlBLPIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlBLPIterator.html#sol-common-ix-DynKwlBLPIterator-method-close' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlBLPIterator-method-close' class='name expandable'>close</a>( <span class='pre'></span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Closes the connection for both map and non map capable clients. ...</div><div class='long'><p>Closes the connection for both map and non map capable clients.</p>\n</div></div></div><div id='method-createBLPConditionFields' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlBLPIterator'>sol.common.ix.DynKwlBLPIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlBLPIterator.html#sol-common-ix-DynKwlBLPIterator-method-createBLPConditionFields' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlBLPIterator-method-createBLPConditionFields' class='name expandable'>createBLPConditionFields</a>( <span class='pre'>ec, focusField, fieldIndex, map, sord</span> ) : String[]<span class=\"signature\"></span></div><div class='description'><div class='short'>Internal function that utilizes the creation of condition_fields passed to the BLP query. ...</div><div class='long'><p>Internal function that utilizes the creation of condition_fields passed to the BLP query.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>ec</span> : de.elo.ix.scripting.ScriptExecContext<div class='sub-desc'><p>IX ScriptExecContext</p>\n</div></li><li><span class='pre'>focusField</span> : String<div class='sub-desc'><p>Currently focused field</p>\n</div></li><li><span class='pre'>fieldIndex</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>map</span> : Object<div class='sub-desc'><p>Map of all entries passed by the client</p>\n</div></li><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'><p>working version of the current sord object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String[]</span><div class='sub-desc'><p>Values for prepared statement</p>\n</div></li></ul></div></div></div><div id='method-formatNumber' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.DynKwlMixin' rel='sol.common.ix.DynKwlMixin' class='defined-in docClass'>sol.common.ix.DynKwlMixin</a><br/><a href='source/lib_sol.common.ix.DynKwlUtils.html#sol-common-ix-DynKwlMixin-method-formatNumber' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlMixin-method-formatNumber' class='name expandable'>formatNumber</a>( <span class='pre'>value, params</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Formats decimal numbers using sol.common.Locale.formatDecimal. ...</div><div class='long'><p>Formats decimal numbers using <a href=\"#!/api/sol.common.Locale-method-formatDecimal\" rel=\"sol.common.Locale-method-formatDecimal\" class=\"docClass\">sol.common.Locale.formatDecimal</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-formatRow' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.DynKwlMixin' rel='sol.common.ix.DynKwlMixin' class='defined-in docClass'>sol.common.ix.DynKwlMixin</a><br/><a href='source/lib_sol.common.ix.DynKwlUtils.html#sol-common-ix-DynKwlMixin-method-formatRow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlMixin-method-formatRow' class='name expandable'>formatRow</a>( <span class='pre'>row</span> )<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Uses this.formatting to apply formatting to a table row. ...</div><div class='long'><p>Uses <code>this.formatting</code> to apply formatting to a table row.</p>\n\n<h1>Format decimal</h1>\n\n<p>See also <a href=\"#!/api/sol.common.Locale-method-formatDecimal\" rel=\"sol.common.Locale-method-formatDecimal\" class=\"docClass\">sol.common.Locale.formatDecimal</a>.</p>\n\n<pre><code>formatting = [\n  { columnNames: [\"MY_OUTPUT_COLUMN1\"], minimumFractionDigits: 0, maximumFractionDigits: 2 },\n  { columnNames: [\"MY_OUTPUT_COLUMN2\", \"ANOTHER_OUTPUT_COLUMN\"], maximumFractionDigits: 4 }\n];\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>row</span> : String[]<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getHeader' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlBLPIterator'>sol.common.ix.DynKwlBLPIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlBLPIterator.html#sol-common-ix-DynKwlBLPIterator-method-getHeader' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlBLPIterator-method-getHeader' class='name expandable'>getHeader</a>( <span class='pre'></span> ) : String[]<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the header of this table that can be displayed by the clients. ...</div><div class='long'><p>Returns the header of this table that can be displayed by the clients.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>String[]</span><div class='sub-desc'><p>Table header</p>\n</div></li></ul></div></div></div><div id='method-getIndexFromName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlBLPIterator'>sol.common.ix.DynKwlBLPIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlBLPIterator.html#sol-common-ix-DynKwlBLPIterator-method-getIndexFromName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlBLPIterator-method-getIndexFromName' class='name expandable'>getIndexFromName</a>( <span class='pre'>name</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-getKeyNames' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlBLPIterator'>sol.common.ix.DynKwlBLPIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlBLPIterator.html#sol-common-ix-DynKwlBLPIterator-method-getKeyNames' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlBLPIterator-method-getKeyNames' class='name expandable'>getKeyNames</a>( <span class='pre'></span> ) : String[]<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the keys of this table that can be used in order to map\nmap or group fields with columns. ...</div><div class='long'><p>Returns the keys of this table that can be used in order to map\nmap or group fields with columns.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>String[]</span><div class='sub-desc'><p>Table keys</p>\n</div></li></ul></div></div></div><div id='method-getMessage' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlBLPIterator'>sol.common.ix.DynKwlBLPIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlBLPIterator.html#sol-common-ix-DynKwlBLPIterator-method-getMessage' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlBLPIterator-method-getMessage' class='name expandable'>getMessage</a>( <span class='pre'></span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the error message that should be displayed by the client\ninstead of the table data. ...</div><div class='long'><p>Returns the error message that should be displayed by the client\ninstead of the table data.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>error message</p>\n</div></li></ul></div></div></div><div id='method-getNextRow' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlBLPIterator'>sol.common.ix.DynKwlBLPIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlBLPIterator.html#sol-common-ix-DynKwlBLPIterator-method-getNextRow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlBLPIterator-method-getNextRow' class='name expandable'>getNextRow</a>( <span class='pre'></span> ) : String[]<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the next row of the table. ...</div><div class='long'><p>Returns the next row of the table.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>String[]</span><div class='sub-desc'><p>Table row</p>\n</div></li></ul></div></div></div><div id='method-getQueryResults' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlBLPIterator'>sol.common.ix.DynKwlBLPIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlBLPIterator.html#sol-common-ix-DynKwlBLPIterator-method-getQueryResults' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlBLPIterator-method-getQueryResults' class='name expandable'>getQueryResults</a>( <span class='pre'>queryConditions</span> ) : de.elo.ix.client.Sord[]<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Retrieves a list of results from a BLP query. ...</div><div class='long'><p>Retrieves a list of results from a BLP query.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>queryConditions</span> : Object<div class='sub-desc'></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.Sord[]</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getRowData' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlBLPIterator'>sol.common.ix.DynKwlBLPIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlBLPIterator.html#sol-common-ix-DynKwlBLPIterator-method-getRowData' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlBLPIterator-method-getRowData' class='name expandable'>getRowData</a>( <span class='pre'>row</span> ) : String[]<span class=\"signature\"></span></div><div class='description'><div class='short'>Within BLP we're basically just passing our result row to our DynKwl. ...</div><div class='long'><p>Within BLP we're basically just passing our result row to our DynKwl.\nYou may overwrite this function for some fancy row preparation</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>row</span> : String[]<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String[]</span><div class='sub-desc'><p>Table row</p>\n</div></li></ul></div></div></div><div id='method-getTableKeyNames' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.DynKwlMixin' rel='sol.common.ix.DynKwlMixin' class='defined-in docClass'>sol.common.ix.DynKwlMixin</a><br/><a href='source/lib_sol.common.ix.DynKwlUtils.html#sol-common-ix-DynKwlMixin-method-getTableKeyNames' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlMixin-method-getTableKeyNames' class='name expandable'>getTableKeyNames</a>( <span class='pre'>focusFieldName</span> ) : String[]<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Determines the table keys for the output of the dynamic kwl. ...</div><div class='long'><p>Determines the table keys for the output of the dynamic kwl.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>focusFieldName</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String[]</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getTitle' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlBLPIterator'>sol.common.ix.DynKwlBLPIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlBLPIterator.html#sol-common-ix-DynKwlBLPIterator-method-getTitle' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlBLPIterator-method-getTitle' class='name expandable'>getTitle</a>( <span class='pre'></span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns a title for this table used by the user interface. ...</div><div class='long'><p>Returns a title for this table used by the user interface.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Title</p>\n</div></li></ul></div></div></div><div id='method-hasMoreRows' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlBLPIterator'>sol.common.ix.DynKwlBLPIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlBLPIterator.html#sol-common-ix-DynKwlBLPIterator-method-hasMoreRows' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlBLPIterator-method-hasMoreRows' class='name expandable'>hasMoreRows</a>( <span class='pre'></span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns true if table has more rows. ...</div><div class='long'><p>Returns true if table has more rows.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>Has more rows</p>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlBLPIterator'>sol.common.ix.DynKwlBLPIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlBLPIterator.html#sol-common-ix-DynKwlBLPIterator-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlBLPIterator-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'></div></li></ul><p>Overrides: <a href=\"#!/api/sol.common.ix.DynKwlMixin-method-initialize\" rel=\"sol.common.ix.DynKwlMixin-method-initialize\" class=\"docClass\">sol.common.ix.DynKwlMixin.initialize</a></p></div></div></div><div id='method-open' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlBLPIterator'>sol.common.ix.DynKwlBLPIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlBLPIterator.html#sol-common-ix-DynKwlBLPIterator-method-open' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlBLPIterator-method-open' class='name expandable'>open</a>( <span class='pre'>ec, sord, fieldName</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Opens a connection for the elo java client and non map field capable clients. ...</div><div class='long'><p>Opens a connection for the elo java client and non map field capable clients.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>ec</span> : de.elo.ix.scripting.ScriptExecContext<div class='sub-desc'>\n</div></li><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'><p>working version of the current sord object</p>\n</div></li><li><span class='pre'>fieldName</span> : String<div class='sub-desc'><p>name of the currently focused field</p>\n</div></li></ul></div></div></div><div id='method-openMap' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlBLPIterator'>sol.common.ix.DynKwlBLPIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlBLPIterator.html#sol-common-ix-DynKwlBLPIterator-method-openMap' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlBLPIterator-method-openMap' class='name expandable'>openMap</a>( <span class='pre'>ec, map, focusName</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Opens a connection for elo wf forms and map field capable components ...</div><div class='long'><p>Opens a connection for elo wf forms and map field capable components</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>ec</span> : de.elo.ix.scripting.ScriptExecContext<div class='sub-desc'>\n</div></li><li><span class='pre'>map</span> : Object<div class='sub-desc'><p>Map of all entries passed by the client</p>\n</div></li><li><span class='pre'>focusName</span> : String<div class='sub-desc'><p>Name of the currently focused field</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloix":true}});